/**********************************************************************
*  WG9914D.h — UART⇔GPIB 转换芯片 WG9914D 轻量级驱动（v1.0.2）
**********************************************************************/
#ifndef _WG9914D_H_
#define _WG9914D_H_

#include <stdint.h>
#include <stddef.h>
#include <stdbool.h>

#ifdef __cplusplus
extern "C" {
#endif

/*--------------------------------------------------------------------
 *  底层抽象接口（用户必须提供）
 *-------------------------------------------------------------------*/
typedef int32_t (*WG9914D_TxFunc)(const uint8_t *buf, uint16_t len); /* 发送 */
typedef void    (*WG9914D_Delay1msFunc)(void);                       /* 延时1 ms */

/*--------------------------------------------------------------------
 *  初始化与运行
 *-------------------------------------------------------------------*/
/**
 * @param tx_cb       串口发送函数
 * @param delay_1ms   精确 1 ms 延时函数
 * @param idn_reply   收到 "*IDN?" 时返回的字符串（结尾无需换行）
 */
void WG9914D_Init(WG9914D_TxFunc       tx_cb,
                  WG9914D_Delay1msFunc delay_1ms,
                  const char          *idn_reply);

/**
 * @brief  串口收到 1 字节后立即调用
 */
void WG9914D_InputByte(uint8_t ch);

/*--------------------------------------------------------------------
 *  发送一行指令并（可选）等待回显
 *-------------------------------------------------------------------*/
/**
 * @param cmd        发送的完整字符串（必须含 '\n'）
 * @param expect1    期望出现的子串 1（可为 NULL / ""）
 * @param expect2    期望出现的子串 2（可为 NULL / ""，任一匹配即成功）
 * @param timeout_ms 最大等待时间；若为 0 则不等待直接返回 true
 * @retval true      收到匹配或不等待
 * @retval false     超时未匹配 / 参数错误
 */
bool WG9914D_SendLineWait(const char *cmd,
                          const char *expect1,
                          const char *expect2,
                          uint32_t    timeout_ms);

#ifdef __cplusplus
}
#endif
#endif /* _WG9914D_H_ */
